<?php
/*
		Author:
				Rusty

		Purpose:
				Helper PHP for DTAS Preview version License Countdown

		Library:


		Note:

 */
function license_controller($argv) {
	$dtas_cfg_path = null;
	$dtas_cfg = null;
	$action = "GET";
	$retCode = 0;

	if(count($argv) < 2) {
		exit(1);
	}

	$dtas_cfg_path = $argv[0];
	$action = $argv[1];

	if($action != "GET" && $action != "SET" && $action != "CHECK") {
		exit(1);
	}

	if(($dtas_cfg = new SimpleXMLElement(file_get_contents($dtas_cfg_path))) == FALSE) {
		exit(1);
	}

	// Try connecting database	
	$dbHost = $dtas_cfg->db->host;
	$dbUser = $dtas_cfg->db->username;
	$dbPassword =  $dtas_cfg->db->password;
	if(($dbconn = pg_connect("host=$dbHost dbname=dtasdb port=5432 user=$dbUser password=$dbPassword")) == FALSE) {
		exit(1);
	}

	date_default_timezone_set("GMT");

	switch($action) {
	case 'GET':
		if(($result = pg_query_params($dbconn, 
			'SELECT value FROM tb_global_setting WHERE key = \'configuration.license.expire_date\'', 
			array())) == FALSE) {
				echo "Failed to query DB\n";
				$retCode = 1;
				break;
			}

		if(($arrResult = pg_fetch_array($result, null, PGSQL_NUM)) == FALSE) {
			break;
		}

		if(count($arrResult) == 0){
			$retCode = 1;
			break;
		}
		echo strftime('%c', $arrResult[0]); 
		break;

	case 'SET':
		$tExpire = new DateTime('now', new DateTimeZone('UTC'));
		$tExpire->add(new DateInterval('P180D'));
		$tExpireStamp = $tExpire->getTimeStamp();

		if(($result = pg_query_params($dbconn, 
			'DELETE FROM tb_global_setting WHERE key = \'configuration.license.expire_date\'', 
			array())) == FALSE) {
				echo "Failed to delete license key\n";
				$retCode = 1;
				break;
			}

		if(($result = pg_query_params($dbconn, 
			'INSERT INTO tb_global_setting(key, value) VALUES(\'configuration.license.expire_date\', $1)', 
			array($tExpireStamp))) == FALSE) {
				echo "Failed to insert license key\n";
				$retCode = 1;
				break;
			}
		break;

	case 'CHECK':
		if(($result = pg_query_params($dbconn,
			'SELECT value FROM tb_global_setting WHERE key = \'configuration.license.expire_date\'',
			array())) == FALSE) {
				echo "Failed to query DB\n";
				$retCode = 1;
				break;
			}

		if(($arrResult = pg_fetch_array($result, null, PGSQL_NUM)) == FALSE) {
			break;
		}

		if(count($arrResult) == 0){
			$retCode = 1;
			break;
		}

		if(time() > (int)$arrResult[0]) {
			echo "<expired>";
		}

		break;
	}

	pg_close($dbconn);
	exit($retCode);
}

